
%==========================================================================%
%   Construct a vector containing the met. names in the rxn system  %
%==========================================================================%

function metlist = f(Rxn_List)

k=1;
metlist = {};

 for i = 1:length(Rxn_List)
     Rxn_List{i} = strrep(Rxn_List{i},' <-> ','|');
     Rxn_List{i} = strrep(Rxn_List{i},' -> ','|');
     Rxn_List{i} = strrep(Rxn_List{i},' + ','|');
     rxnmets = strread(Rxn_List{i},'%s','delimiter','|');
     rxnmets = strtrim(rxnmets);
     a = length(rxnmets); % how many mets are there in the rxn i.
     for j = 1:a
         if length(strmatch(rxnmets(j),metlist,'exact')) == 0 % or use isempty
            metlist(k) = rxnmets(j);
            k = k + 1;
         end
     end
 end
 metlist = strtrim(metlist)'; % not finalized: many of mets include stoich coefficients together.

 for i = 1:length(metlist)
     [outa, outb, outc, outd] = strread(metlist{i},'%s %s %s %s','delimiter',' '); % separate the pseudo metabolites into pieces
     if length(str2num( char(outa) ))~= 0
        metlist{i} = [char(outb) ' ' char(outc) ' ' char(outd)];
     end
 end
 metlist = strtrim(metlist); %remove spaces added during strcat 
 
 % due to the availability of coeffs together with some met names, some of
 % the duplicates could not be identified. Below is a loop to handle this.
 for i = 1:length(metlist)
     duplics = strmatch(metlist(i),metlist,'exact');
     d = length(duplics);

     if d >=2                   % if more than one match
         duplics(1) = [];       % keep the first match
         metlist(duplics) = []; % remove the others.
     end
     if i >=length(metlist); break; end;
 end

 j = 1;
 for i = 1: length(metlist)  % to detect empty entries in metlist
     if length(strmatch('',metlist(i),'exact') ) ~= 0
      del(j) = i;    j = j + 1;
     end
 end
 
if j >1;  metlist(del) = []; end;


metlist;
